<?php

function generate_config()
{
    include_once("../config/node_parameters.php");  /* DO NOT DELETE THIS LINE */ //All link parameters
    
    
return "
    
# JUNIPER Configuration on device IP: $IP
# ########################################################################## !!

#Source interface config #####################################################################################
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC description $MAP_NAME
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC vlan-tags outer $S_VLAN inner $C_VLAN
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet filter input $MAP_NAME-IN
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet filter output $MAP_NAME-OUT
#set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet policer arp ARP-LIMIT
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet policer input $MAP_NAME-IN
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet policer output $MAP_NAME-OUT
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet address $IP_P2P_GATEWAY/$IP_P2P_MASK
    

##### IN filter  #####################################################################################
set  firewall filter $MAP_NAME-IN term T1 from destination-address $IP_P2P_GATEWAY/32
set  firewall filter $MAP_NAME-IN term T1 from protocol icmp
set  firewall filter $MAP_NAME-IN term T1 then accept
    
set  firewall filter $MAP_NAME-IN term T2 from destination-address $IP_P2P_GATEWAY/32
set  firewall filter $MAP_NAME-IN term T2 from protocol tcp
set  firewall filter $MAP_NAME-IN term T2 then discard
    
#set  firewall filter $MAP_NAME-IN term T3 from destination-address 192.168.0.0/16
#set  firewall filter $MAP_NAME-IN term T3 from destination-address 172.16.0.0/12
#set  firewall filter $MAP_NAME-IN term T3 from destination-address 10.0.0.0/8 
#set  firewall filter $MAP_NAME-IN term T3 then discard
    
set  firewall filter $MAP_NAME-IN term T4 from source-address $IP_P2P
set  firewall filter $MAP_NAME-IN term T4 then dscp 0
set  firewall filter $MAP_NAME-IN term T4 then accept
    
set  firewall filter $MAP_NAME-IN term T5 then discard

##### OUT filter ############################################################################################
set  firewall filter $MAP_NAME-OUT term T1 from destination-address $IP_P2P
set  firewall filter $MAP_NAME-OUT term T1 then accept
set  firewall filter $MAP_NAME-OUT term T2 then discard

##### Policers ##############################################################################################

set  firewall policer $MAP_NAME-IN if-exceeding bandwidth-limit $UPLOAD
set  firewall policer $MAP_NAME-IN if-exceeding burst-size-limit 10m
set  firewall policer $MAP_NAME-IN then discard

set  firewall policer $MAP_NAME-OUT if-exceeding bandwidth-limit $DOWNLOAD
set  firewall policer $MAP_NAME-OUT if-exceeding burst-size-limit 10m
set  firewall policer $MAP_NAME-OUT then discard
		
set firewall policer ARP-LIMIT if-exceeding bandwidth-limit 8k
set firewall policer ARP-LIMIT if-exceeding burst-size-limit 1500
set firewall policer ARP-LIMIT then discard



#Destination interface config ##############################################################################
#set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC description $MAP_NAME
#set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC encapsulation vlan-ccc
#set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC vlan-id-list $C_VLAN
#set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC input-vlan-map push
#set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC input-vlan-map vlan-id $S_VLAN
#set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC output-vlan-map pop
#set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family ccc policer input $MAP_NAME-IN
#set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family ccc policer output $MAP_NAME-OUT

##### Policers ##############################################################################################

#set  firewall policer $MAP_NAME-IN if-exceeding bandwidth-limit $UPLOAD
#set  firewall policer $MAP_NAME-IN if-exceeding burst-size-limit 10m
#set  firewall policer $MAP_NAME-IN then discard

#set  firewall policer $MAP_NAME-OUT if-exceeding bandwidth-limit $DOWNLOAD
#set  firewall policer $MAP_NAME-OUT if-exceeding burst-size-limit 10m
#set  firewall policer $MAP_NAME-OUT then discard

#set  protocols l2circuit neighbor $NEIGHBOR_DST interface $INTERFACE_SRC.$SUBINTERFACE_SRC virtual-circuit-id $C_VLAN
#set  protocols l2circuit neighbor $NEIGHBOR_DST interface $INTERFACE_SRC.$SUBINTERFACE_SRC encapsulation-type ethernet
##set  protocols l2circuit neighbor $NEIGHBOR_DST interface $INTERFACE_SRC.$SUBINTERFACE_SRC encapsulation-type ethernet-vlan
#set  protocols l2circuit neighbor $NEIGHBOR_DST interface $INTERFACE_SRC.$SUBINTERFACE_SRC flow-label-transmit
#set  protocols l2circuit neighbor $NEIGHBOR_DST interface $INTERFACE_SRC.$SUBINTERFACE_SRC flow-label-receive
#set  protocols l2circuit neighbor $NEIGHBOR_DST interface $INTERFACE_SRC.$SUBINTERFACE_SRC mtu 9000

";

}

?>
